/*
 * Decompiled with CFR 0.152.
 */
package view;

import data.Constants;
import java.util.ArrayList;
import model.EnemyModel;
import org.lwjgl.opengl.GL11;

public class BackgroundDrawer {
    public static int blockSize;
    public static float offsetX;
    public static float offsetY;
    public float cOffsetX;
    public float cOffsetY;
    float space = (float)((double)(Constants.VIEW_WIDTH / 2) * Math.sqrt(2.0) / (double)(Constants.numberOfRings + 1));
    int maxRings = (int)Math.ceil(Math.sqrt(Math.pow(Constants.VIEW_HEIGHT, 2.0) + Math.pow(Constants.VIEW_HEIGHT, 2.0)) / (double)this.space);
    private ArrayList<Coord> circlePos = new ArrayList();
    private boolean draw;
    private int drawCt;
    private int tunnelDelay = Constants.tunnelDelay;

    public BackgroundDrawer() {
        blockSize = Constants.blockSize;
        if (Constants.backgroundType == 2) {
            blockSize = (int)((double)blockSize * Math.sqrt(2.0));
        }
        offsetY = 0.0f;
        offsetX = 0.0f;
        this.cOffsetY = 0.0f;
        this.cOffsetX = 0.0f;
        this.draw = false;
        this.drawCt = 0;
    }

    public void move(float xVel, float yVel) {
        block3: {
            block4: {
                offsetX += xVel;
                offsetY += yVel;
                this.cOffsetX += xVel;
                this.cOffsetY += yVel;
                if (Constants.backgroundType != 4) {
                    offsetX %= (float)blockSize;
                    offsetY %= (float)blockSize;
                }
                if (xVel == 0.0f && yVel == 0.0f) break block3;
                ++this.drawCt;
                this.drawCt %= this.tunnelDelay;
                this.draw = this.drawCt == 0;
                if (Constants.backgroundType != 5 && Constants.backgroundType != 7) break block4;
                int i = 0;
                while (i < this.circlePos.size()) {
                    this.circlePos.get(i).incRad(this.circlePos);
                    ++i;
                }
                break block3;
            }
            if (Constants.backgroundType != 6 && Constants.backgroundType != 8) break block3;
            int i = 0;
            while (i < this.circlePos.size()) {
                this.circlePos.get(i).decRad(this.circlePos);
                ++i;
            }
        }
    }

    public static void drawHighlight(float x, float y, float radius, EnemyModel e) {
        GL11.glPushMatrix();
        GL11.glEnable(3042);
        GL11.glBlendFunc(774, 1);
        float[] eCol = e.geteCol();
        float alpha = e.getLife() / (float)(Constants.FADE_TIME / 2);
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        GL11.glColor4f(eCol[0], eCol[1], eCol[2], alpha *= Constants.highlightAlpha);
        int i = 0;
        while (i <= Constants.VIEW_WIDTH / blockSize) {
            if (offsetX + (float)(i * blockSize) >= x - radius && offsetX + (float)(i * blockSize) <= x + radius) {
                GL11.glBegin(1);
                GL11.glVertex2f(offsetX + (float)(i * blockSize), y - radius);
                GL11.glVertex2f(offsetX + (float)(i * blockSize), y + radius);
                GL11.glEnd();
            }
            ++i;
        }
        i = 0;
        while (i <= Constants.VIEW_WIDTH / blockSize) {
            if (offsetY + (float)(i * blockSize) >= y - radius && offsetY + (float)(i * blockSize) <= y + radius) {
                GL11.glBegin(1);
                GL11.glVertex3f(x - radius, offsetY + (float)(i * blockSize), 1.0f);
                GL11.glVertex3f(x + radius, offsetY + (float)(i * blockSize), 1.0f);
                GL11.glEnd();
            }
            ++i;
        }
        GL11.glDisable(3042);
        GL11.glPopMatrix();
    }

    public void draw() {
        block18: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block17: {
                                        GL11.glColor4f(Constants.backgroundColor[0], Constants.backgroundColor[1], Constants.backgroundColor[2], 1.0f);
                                        if (Constants.backgroundType != 1) break block17;
                                        int i = 0;
                                        while (i <= Constants.VIEW_WIDTH / blockSize) {
                                            GL11.glBegin(1);
                                            GL11.glVertex2f(offsetX + (float)(i * blockSize), 0.0f);
                                            GL11.glVertex2f(offsetX + (float)(i * blockSize), Constants.VIEW_HEIGHT);
                                            GL11.glEnd();
                                            ++i;
                                        }
                                        i = 0;
                                        while (i <= Constants.VIEW_WIDTH / blockSize) {
                                            GL11.glBegin(1);
                                            GL11.glVertex3f(0.0f, offsetY + (float)(i * blockSize), 1.0f);
                                            GL11.glVertex3f(Constants.VIEW_WIDTH, offsetY + (float)(i * blockSize), 1.0f);
                                            GL11.glEnd();
                                            ++i;
                                        }
                                        break block18;
                                    }
                                    if (Constants.backgroundType != 2) break block19;
                                    int i = 0;
                                    while (i <= Constants.VIEW_WIDTH * 2 / blockSize) {
                                        GL11.glBegin(1);
                                        GL11.glVertex2f(offsetX + (float)(i * blockSize) - (float)Constants.VIEW_WIDTH - (float)blockSize, offsetY - (float)blockSize);
                                        GL11.glVertex2f(offsetX + (float)(i * blockSize) + (float)blockSize, (float)Constants.VIEW_HEIGHT + offsetY + (float)blockSize);
                                        GL11.glEnd();
                                        ++i;
                                    }
                                    i = 0;
                                    while (i <= Constants.VIEW_WIDTH * 2 / blockSize) {
                                        GL11.glBegin(1);
                                        GL11.glVertex2f(offsetX + (float)(i * blockSize) - (float)Constants.VIEW_WIDTH - (float)blockSize, offsetY + (float)Constants.VIEW_HEIGHT + (float)blockSize);
                                        GL11.glVertex2f(offsetX + (float)(i * blockSize) + (float)blockSize, offsetY - (float)blockSize);
                                        GL11.glEnd();
                                        ++i;
                                    }
                                    break block18;
                                }
                                if (Constants.backgroundType != 3) break block20;
                                GL11.glPushMatrix();
                                GL11.glTranslatef(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2, 0.0f);
                                GL11.glColor3f(0.08f, 0.08f, 0.08f);
                                float width = 0.0f;
                                int steps = 0;
                                int i = 0;
                                while (i < Constants.numberOfRings) {
                                    GL11.glBegin(3);
                                    steps = (int)(width += this.space);
                                    int f = 0;
                                    while (f <= steps) {
                                        double t = (double)f * 2.0 * Math.PI / (double)steps;
                                        double x = (double)width * Math.cos(t);
                                        double y = (double)width * Math.sin(t);
                                        GL11.glVertex2d(x, y);
                                        ++f;
                                    }
                                    GL11.glEnd();
                                    ++i;
                                }
                                GL11.glPopMatrix();
                                break block18;
                            }
                            if (Constants.backgroundType != 4) break block21;
                            GL11.glPushMatrix();
                            GL11.glTranslatef(offsetX + (float)(Constants.VIEW_WIDTH / 2), offsetY + (float)(Constants.VIEW_HEIGHT / 2), 0.0f);
                            float distFromOrig = (float)Math.sqrt(Math.pow(offsetX, 2.0) + Math.pow(offsetY, 2.0));
                            int ringsToCenter = (int)(distFromOrig / this.space) - this.maxRings / 2;
                            int numberOfRings = this.maxRings;
                            if (ringsToCenter < 0) {
                                ringsToCenter = 0;
                                numberOfRings = (int)((float)(this.maxRings / 2) + distFromOrig / this.space);
                            }
                            int c = 1;
                            while (c <= numberOfRings) {
                                int steps = 15 * c + 2;
                                GL11.glBegin(3);
                                int f = 0;
                                while (f <= steps) {
                                    float t = (float)((double)f * 2.0 * Math.PI / (double)steps);
                                    float x = (float)((double)(this.space * (float)(c + ringsToCenter)) * Math.cos(t));
                                    float y = (float)((double)(this.space * (float)(c + ringsToCenter)) * Math.sin(t));
                                    GL11.glVertex2d(x, y);
                                    ++f;
                                }
                                GL11.glEnd();
                                ++c;
                            }
                            GL11.glPopMatrix();
                            break block18;
                        }
                        if (Constants.backgroundType != 5) break block22;
                        if (this.circlePos.size() == 0 || this.draw) {
                            this.circlePos.add(new Coord(this.cOffsetX, this.cOffsetY, 10.0f));
                        }
                        int i = 0;
                        while (i < this.circlePos.size()) {
                            this.circlePos.get(i).draw(this.cOffsetX, this.cOffsetY);
                            ++i;
                        }
                        break block18;
                    }
                    if (Constants.backgroundType != 6) break block23;
                    if (this.circlePos.size() == 0 || this.draw) {
                        this.circlePos.add(new Coord(this.cOffsetX, this.cOffsetY, 700.0f));
                    }
                    int i = 0;
                    while (i < this.circlePos.size()) {
                        this.circlePos.get(i).draw(this.cOffsetX, this.cOffsetY);
                        ++i;
                    }
                    break block18;
                }
                if (Constants.backgroundType != 7) break block24;
                if (this.circlePos.size() == 0 || this.draw) {
                    this.circlePos.add(new Coord(0.0f, 0.0f, 10.0f));
                }
                int i = 0;
                while (i < this.circlePos.size()) {
                    this.circlePos.get(i).drawStatic();
                    ++i;
                }
                break block18;
            }
            if (Constants.backgroundType != 8) break block18;
            if (this.circlePos.size() == 0 || this.draw) {
                this.circlePos.add(new Coord(0.0f, 0.0f, 700.0f));
            }
            int i = 0;
            while (i < this.circlePos.size()) {
                this.circlePos.get(i).drawStatic();
                ++i;
            }
        }
    }

    private class Coord {
        float x;
        float y;
        float radius;
        float alpha;

        private Coord(float x, float y, float radius) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.alpha = 0.06f;
        }

        private boolean equals(Coord that) {
            return that.x == this.x && that.y == this.y;
        }

        private void incRad(ArrayList<Coord> c) {
            this.radius = (float)((double)this.radius * 1.05);
            if (this.radius >= 700.0f) {
                c.remove(this);
            }
        }

        private void decRad(ArrayList<Coord> c) {
            this.radius = (float)((double)this.radius * 0.95);
            if (this.radius <= 1.0f) {
                c.remove(this);
            }
        }

        private void draw(float offX, float offY) {
            GL11.glPushMatrix();
            GL11.glTranslatef(-this.x + offX + (float)(Constants.VIEW_WIDTH / 2), -this.y + offY + (float)(Constants.VIEW_HEIGHT / 2), 0.0f);
            GL11.glColor3f(this.alpha, this.alpha, this.alpha);
            int steps = (int)(this.radius + 5.0f);
            GL11.glBegin(3);
            int f = 0;
            while (f <= steps) {
                float t = (float)((double)f * 2.0 * Math.PI / (double)steps);
                float x = (float)((double)this.radius * Math.cos(t));
                float y = (float)((double)this.radius * Math.sin(t));
                GL11.glVertex2d(x, y);
                ++f;
            }
            GL11.glEnd();
            GL11.glPopMatrix();
        }

        private void drawStatic() {
            GL11.glPushMatrix();
            GL11.glTranslatef(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2, 0.0f);
            GL11.glColor3f(this.alpha, this.alpha, this.alpha);
            int steps = (int)(this.radius + 5.0f);
            GL11.glBegin(3);
            int f = 0;
            while (f <= steps) {
                float t = (float)((double)f * 2.0 * Math.PI / (double)steps);
                float x = (float)((double)this.radius * Math.cos(t));
                float y = (float)((double)this.radius * Math.sin(t));
                GL11.glVertex2d(x, y);
                ++f;
            }
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }
}

